/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.core;

import com.google.common.collect.Multimap;
import dev.xkmc.l2artifacts.content.core.ArtifactStats;
import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.init.L2Artifacts;
import dev.xkmc.l2damagetracker.contents.curios.AttrTooltip;
import dev.xkmc.l2library.capability.conditionals.ConditionalData;
import dev.xkmc.l2library.capability.conditionals.TokenKey;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ArtifactCurioCap
implements ICurio {
    private final ItemStack stack;
    private final LazyOptional<ArtifactStats> stats;

    public ArtifactCurioCap(ItemStack stack) {
        this.stack = stack;
        this.stats = stack.m_41783_() != null && stack.m_41783_().m_128441_("ArtifactData") ? LazyOptional.of(() -> Objects.requireNonNull((ArtifactStats)TagCodec.fromTag((CompoundTag)stack.m_41783_().m_128469_("ArtifactData"), ArtifactStats.class))) : LazyOptional.empty();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public Optional<ArtifactStats> getStats() {
        return this.stats.resolve();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
        if (this.getStats().isPresent()) {
            return this.getStats().get().buildAttributes(slotContext.identifier() + slotContext.index());
        }
        return super.getAttributeModifiers(slotContext, uuid);
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips) {
        if (this.getStats().isPresent()) {
            List ans = AttrTooltip.modifyTooltip(tooltips, this.getStats().get().buildAttributes(""), (boolean)true);
            if (ans.size() <= 2) {
                return new ArrayList<Component>();
            }
            return ans;
        }
        return tooltips;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack) {
        Item item = this.stack.m_41720_();
        if (item instanceof BaseArtifact) {
            BaseArtifact base = (BaseArtifact)item;
            base.set.get().update(slotContext);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack) {
        Item item = this.stack.m_41720_();
        if (item instanceof BaseArtifact) {
            BaseArtifact base = (BaseArtifact)item;
            base.set.get().update(slotContext);
        }
    }

    public void curioTick(SlotContext slotContext) {
        block3: {
            try {
                Item item = this.stack.m_41720_();
                if (item instanceof BaseArtifact) {
                    BaseArtifact base = (BaseArtifact)item;
                    base.set.get().tick(slotContext);
                }
            }
            catch (Exception e) {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block3;
                Player player = (Player)livingEntity;
                ((ConditionalData)ConditionalData.HOLDER.get((Player)player)).data.entrySet().removeIf(x -> ((TokenKey)x.getKey()).type().equals("l2artifacts"));
                L2Artifacts.LOGGER.error("Player " + player + " has invalid artifact data for " + this.stack.m_41720_() + ". This could be a bug.");
            }
        }
    }
}

